--[[---------------------------------------------------------------------------
	Chocolatier Two Generic Character Dialog
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local char = LCharacter:ByName("cay_hotelkeep")		-- Evangeline
local yes = gDialogTable.yes
local ok = gDialogTable.ok or yes or "done"
local no = gDialogTable.no
local name = gDialogTable.name or char.name or "chartalk"

local body = "tutor00_pretalk"
if body then body = LabelString(body) end
if gDialogTable.fullbody then body = "#"..gDialogTable.fullbody end

local width = 580
local height = 280

local xLeft = kCenter-ui.devButtonW/2
local xRight = kCenter+ui.devButtonW/2

-------------------------------------------------------------------------------

local xLeft = (width - ui.charW)/2 - ui.devButtonW
local xRight = (width - ui.charW) - xLeft - ui.devButtonW
local xCenter = (width - ui.charW - ui.devButtonW) / 2
MakeDialog
{
	name=name,
	Bitmap
	{
		x=kCenter,y=kCenter,w=ui.screenWidth,h=ui.screenHeight,
		image="ports/cayenne",
	},
	Frame
	{
		x=ui.xOffset+(ui.screenWidth-width)/2,y=50+ui.yOffset,w=width,h=height, color=CharacterColor,
		
		Text { x=10,y=5,w=width-ui.charW-10,h=height-55, label=body, font=dialogFont, flags=kHAlignLeft+kVAlignCenter },
		
		TextButton { x=xLeft,y=height-45, name="yes", close=true, label=yes },
		TextButton { x=xRight,y=height-45, name="no", close=true, label=no },
		TextButton { x=(width-ui.charW-ui.devButtonW)/2,y=height-45, name="ok", close=true, label=ok, default=true },
	},
	char:Visual(ui.screenWidth-(ui.screenWidth-width)/2-ui.charW+ui.xOffset, ui.yOffset, charNameFontDark),
}

if no then
	-- Yes/No dialog -- no single OK
	EnableWindow("ok", false)
else
	-- OK dialog -- no yes/no
	EnableWindow("yes", false)
	EnableWindow("no", false)
end
